<?php

namespace Modules\Hotel\App\Listeners;

use App\Sys\Services\SessionServices;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\Hotel\Sys\Services\BookingServices;
use Modules\Hotel\Sys\Services\HotelServices;

class SaveFinshedListener implements ShouldQueue
{
    /**
     * Create the event listener.
     */

    use InteractsWithQueue;
    /**
     * Handle the event.
     */
    public function handle(SaveFinshedHotel $event): void
    {

        $hotel = new BookingServices();
        $hotel->mappingData($event->session);

    }
}
